/* sefvals.h - SAM-FS system error facility (SEF)  information.
 *
 *      Description:
 *          Definitions for SAM-FS system error facility
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *      Copyright (c) 2004 Sun Microsystems, Inc.
 *      All Rights Reserved.
 *
 *      Government Rights Notice
 *      Use, duplication, or disclosure by the U.S. Government is
 *      subject to restrictions set forth in the Sun Microsystems,
 *      Inc. license agreements and as provided in DFARS 227.7202-1(a)
 *      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
 *      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
 *      as applicable.  Sun Microsystems, Inc.
 *
 *    SAM-QFS_notice_end
 */

#if !defined(_AML_SEFVALS_H)
#define _AML_SEFVALS_H

#pragma ident "$Id: sefvals.h,v 1.5 2004/03/03 15:55:58 cp129962 Exp $"

#ifndef SEFCODE

#ifndef SEFAPP

extern boolean_t	sef_on;			/* B_TRUE if sef is on; B_FALSE if not */

extern int			sef_file;		/* fd of sef log file */

extern boolean_t	sef_status(); /* check if sef is on and open sef log */

extern void			sef_init(dev_ent_t *, int);

extern int			sef_data(dev_ent_t *, int);

extern int			sef_data_page(dev_ent_t *, int, uchar_t *, int);

#endif /* !SEFAPP */
#endif /* !SEFCODE */

/*
 * Use a macro to specify which log sense pages we're interested in.
 * Right now, those are:
 * 02	write error counter page
 * 03	read error counter page
 * 06	nonmedia error page
 *
 * If the list log sense pages used for SEF is changed then SEFPAGE
 * needs to be changed.
 */

#define		SEF_WR_ERR_LOG_PG 	2
#define		SEF_RD_ERR_LOG_PG 	3
#define		SEF_NON_MEDIA_LOG_PG 	6

#define		SEFPAGE(pg)\
	((pg == SEF_WR_ERR_LOG_PG || pg == SEF_RD_ERR_LOG_PG || \
	  pg == SEF_NON_MEDIA_LOG_PG) ? \
		B_TRUE : B_FALSE)

#define		SEF_INQ_TP_TYPE		1
#define		SEF_INQ_MC_TYPE		8

#define		SEFMAGIC	0x94F

#define		SEFVERSION	1

#define		SEFFILE		SAM_VARIABLE_PATH"/sef/sefdata"

#endif /* !defined(_AML_SEFVALS_H) */
