#!/bin/csh -f

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#      Copyright (c) 2004 Sun Microsystems, Inc.
#      All Rights Reserved.
#
#      Government Rights Notice
#      Use, duplication, or disclosure by the U.S. Government is
#      subject to restrictions set forth in the Sun Microsystems,
#      Inc. license agreements and as provided in DFARS 227.7202-1(a)
#      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
#      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
#      as applicable.  Sun Microsystems, Inc.
#
#    SAM-QFS_notice_end

#
#   /etc/opt/SUNWsamfs/scripts/recycler.sh - post-process a VSN after recycler has
#   drained it of all known active archive copies.
#
#   Arguments are:
#      $1 - generic media type "od" or "tp" - used to construct the name
#           of the appropriate label command: odlabel or tplabel
#
#      $2 - VSN being post-processed
#
#      $3 - MID in the library where the VSN is located
#
#      $4 - equipment number of the library where the VSN is located
#  
#      $5 - actual media type ("mo", "lt", etc.) - used to chmed
#           the media if required
#
#      $6 - family set name of the physical library, or the string
#           "hy" for the historian library.    This can be used to
#           handle recycling of off-site media, as shown below.
#
#	   $7 - VSN modifier, used for optical and D2 media
#
#
# $Id: recycler.sh,v 1.7 2004/04/28 19:20:27 dp150627 Exp $
#

#   It is a good idea to log the calls to this script
#echo `date` $* >>  /var/opt/SUNWsamfs/recycler.sh.log

#   As an example, if uncommented, the following lines will relabel the VSN,
#   if it exists in a physical library.  If the VSN is in the historian
#   catalog (e.g., it's been exported from a physical library and moved
#   to off-site storage), then email is sent to "root" informing that the
#   medium is ready to be returned to the site and reused.
#
#set stat=0
#if ( $6 != hy ) then
#    /opt/SUNWsamfs/sbin/chmed -R $5.$2
#    /opt/SUNWsamfs/sbin/chmed -W $5.$2
#    if ( $1 != "od" ) then
#        /opt/SUNWsamfs/sbin/${1}label -w -vsn $2 -old $2 $4\:$3
#		if ( $status != 0 ) then
#		    set stat = 1
#		endif
#    else
#        /opt/SUNWsamfs/sbin/${1}label -w -vsn $2 -old $2 $4\:$3\:$7
#		if ( $status != 0 ) then
#		    set stat = 1
#		endif
#    endif
#else
#    mail root <</eof
#VSN $2 of type $5 is devoid of active archive
#images.  It is currently in the historian catalog, which indicates that
#it has been exported from the on-line libraries.
#
#You should import it to the appropriate library, and relabel it using
#${1}label.
#
#This message will continue to be sent to you each time the recycler
#runs, until you relabel the VSN, or you use the SAM-FS samu or SAM-QFS
#Manager programs to export this medium from the historian catalog to
#suppress this message.
#/eof
#endif
#echo `date` $* done >>  /var/opt/SUNWsamfs/recycler.sh.log
#if ( $stat != 0 ) then
#	exit 1
#else
#	exit 0
#endif
#
#
#   These lines would inform "root" that the VSN should be removed from the
#   robotic library:
#
#mail root <</eof 
#VSN $2 in library $4 is ready to be shelved off-site.
#/eof
#echo `date` $* done >>  /var/opt/SUNWsamfs/recycler.sh.log
#exit 0


#  The default action is to mail a message reminding you to set up this 
#  file.  You should comment out these lines (through and including the /eof
#  below) after you've set up this file.
#
mailx -s "Robot $6 at hostname `hostname` recycle." root <</eof
The /etc/opt/SUNWsamfs/scripts/recycler.sh script was called by the SAM-FS recycler
with the following arguments:

      Media type: $5($1)  VSN: $2  Slot: $3  Eq: $4 
      Library: $6

/etc/opt/SUNWsamfs/scripts/recycler.sh is a script which is called when the recycler
determines that a VSN has been drained of all known active archive
copies.  You should determine your site requirements for disposition of
recycled media - some sites wish to relabel and reuse the media, some
sites wish to take the media out of the library for possible later use
to access historical files.  Consult the recycler(1m) man page for more
information.
/eof
#echo `date` $* done >>  /var/opt/SUNWsamfs/recycler.sh.log
exit 0
