% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_fetch_iiv}
\alias{system_fetch_iiv}
\title{Fetch Variability Terms}
\usage{
system_fetch_iiv(cfg, IIV1, IIV2)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{IIV1}{row name of the variance/covariance matrix}

\item{IIV2}{column name of the variance/covariance matrix}
}
\value{
Value from the variance/covariance matrix
}
\description{
Extract elements of the current variance/covariance matrix
specified in the system file with \code{<IIV:?:?> ?}, \code{<IIVCOR:?:?>?}, \code{<IIVSET:?:?> ?}, \code{<IIVCORSET:?:?>?}
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Covariance term for ETACL and ETAVc
val = system_fetch_iiv(cfg, IIV1="ETACL", IIV2="ETAVc")
}
}
\seealso{
\code{\link{system_set_iiv}}
}
