% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pplist-data}
\alias{pplist-data}
\alias{pplist_samecard}
\alias{pplist_diffcard}
\title{Simulated Point Pattern Lists}
\format{Objects of class \code{pplist}, which are essentially lists of \code{ppp}-objects.}
\usage{
pplist_samecard

pplist_diffcard
}
\description{
Lists of simulated point patterns for illustrating the computation of barycenters.
}
\details{
\code{pplist_samecard} contains 80 point patterns of 100 points each. The patterns
were independently generated from a distribution that creates quite distinctive clusters.

\code{pplist_diffcard} contains 50 point patterns with cardinalities ranging from 17 to 42. 
The patterns were independently generated from a distribution that creates overlapping clusters.
}
\examples{
# plot the first eight patterns of each data set
plot(superimpose(pplist_samecard[1:8]), legend=FALSE, cex=0.4, cols=1:8)
plot(superimpose(pplist_diffcard[1:8]), legend=FALSE, cex=0.4, cols=1:8)
              
}
\author{
Raoul Müller  \email{raoul.mueller@uni-goettingen.de}\cr
        Dominic Schuhmacher \email{schuhmacher@math.uni-goettingen.de}
}
\keyword{datasets}
