% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{ColorKeyTricolore}
\alias{ColorKeyTricolore}
\title{Ternary Balance Scheme Legend}
\usage{
ColorKeyTricolore(
  center,
  breaks,
  h_,
  c_,
  l_,
  contrast,
  spread,
  label_as,
  show_center,
  limits = matrix(0:1, nrow = 2, ncol = 3)
)
}
\arguments{
\item{center}{Ternary coordinates of the grey-point.}

\item{breaks}{Number of breaks in the discrete color scale. An integer >1.
Values above 99 imply no discretization.}

\item{h_}{Primary hue of the first ternary element in angular degrees [0, 360].}

\item{c_}{Maximum possible chroma of mixed colors [0, 200].}

\item{l_}{Lightness of mixed colors [0, 100].}

\item{contrast}{Lightness contrast of the color scale [0, 1).}

\item{spread}{Spread of the color scale around center > 0.}

\item{label_as}{"pct" for percent-share labels or "pct_diff" for
percent-point-difference from center labels.}

\item{show_center}{Should the center be marked on the legend? (logical)}

\item{limits}{A 2 by 3 matrix of lower and upper limits for p1, p2 and p3.}
}
\value{
A ggtern grob.
}
\description{
Plot a ternary balance scheme legend.
}
\examples{
tricolore:::ColorKeyTricolore(center = rep(1/3, 3), breaks = 4,
                              h_ = 80, c_ = 140, l_ = 80,
                              contrast = 0.4, spread = 1,
                              label_as = "pct", show_center = FALSE)

}
\keyword{internal}
