% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{meld_na_US}
\alias{meld_na_US}
\title{MELD-Na score (US units)}
\usage{
meld_na_US(INR, bili, creat, Na, dialysis)
}
\arguments{
\item{INR}{numeric vector of INR}

\item{bili}{numeric vector of serum bilirubin (mg/dl)}

\item{creat}{numeric vector of serum creatinine (mg/dl)}

\item{Na}{numeric vector of serum sodium (mmol/l)}

\item{dialysis}{whether on dialysis/CVVH (1 = yes, 0 = no)}
}
\value{
numeric vector of MELD-Na scores
}
\description{
A wrapper for meld_na(), a vectorised function to calculate the MELD-Na score,
a variant of the MELD score incorporating
serum sodium levels. In this wrapper function, bilirubin and creatinine are in mg/dl.
}
\details{
Reference: Biggins SW, Kim WR, Terrault NA, et al. Evidence-based incorporation of serum sodium
concentration into MELD. Gastroenterology 2006; 130(6):1652-60.
}
\examples{
meld_na_US(INR = 1.8, bili = 2, creat = 2, Na = 131, dialysis = 0)
}
