% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{meld}
\alias{meld}
\title{MELD score}
\usage{
meld(INR, bili, creat, dialysis, units = "SI")
}
\arguments{
\item{INR}{numeric vector of INR}

\item{bili}{numeric vector of bilirubin (µmol/l)}

\item{creat}{numeric vector of creatinine (µmol/l)}

\item{dialysis}{numeric vector of whether on dialysis/CVVH (1 = yes, 2 = no)}

\item{units}{Units for bilirubin and creatinine ("SI" for µmol/l (default), "US" for mg/dl)}
}
\value{
MELD score
}
\description{
A vectorised function to calculate the MELD score using µmol/l for bilirubin and creatinine.
The units can be changed to mg/dl by setting the optional units parameter to "US". If the
patient is on CVVH or has been dialysed at least twice in the same week, the dialysis argument
should be set to 1, which changes the creatinine level used in the formula to 4mg/dl (353µmol/l).
Following UNOS guidelines, the values for INR as well bilirubin and creatinine (in mg/dl) are
set to a minimum value of 1 if less than 1.0
}
\details{
Reference: Kamath PS, Wiesner RH, Malinchoc M, et al. A model to predict survival in patients
with end-stage liver disease. Hepatology 2001; 33:464-470.
}
\examples{
meld(INR = 2.0, bili = 54, creat = 170, dialysis = 0)
meld(INR = 2.0, bili = 3.1, creat = 1.9, dialysis = 0, units = "US")
}
