% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DateModel-class}
\alias{DateModel-class}
\alias{.DateModel}
\title{Date Model}
\description{
An S4 class to store the event and accumulation times of archaeological
 assemblages.
}
\section{Slots}{

\describe{
\item{\code{id}}{A \code{\link{character}} string specifying the unique
identifier of the corresponding matrix (UUID v4).}

\item{\code{counts}}{A numeric matrix of count data.}

\item{\code{level}}{A length-one \code{\link{numeric}} vector giving the
confidence level.}

\item{\code{model}}{A \code{\link[stats:lm]{multiple linear model}}: the Gaussian
multiple linear regression model fitted for event date estimation and
prediction.}

\item{\code{rows}}{A four columns \code{\link{numeric}} matrix giving the predicted
event dates for each archaeological assemblage, with the following columns:
\describe{
 \item{date}{The event date estimation.}
 \item{lower}{The lower boundary of the confidence interval.}
 \item{upper}{The upper boundary of the confidence interval.}
 \item{error}{The standard error of predicted dates.}
}}

\item{\code{columns}}{A four columns \code{\link{numeric}} matrix giving the
predicted event dates for each archaeological type or fabric, with the
following columns:
\describe{
 \item{date}{The event date estimation.}
 \item{lower}{The lower boundary of the confidence interval.}
 \item{upper}{The upper boundary of the confidence interval.}
 \item{error}{The standard error of predicted dates.}
}}

\item{\code{accumulation}}{A two columns \code{\link{numeric}} matrix giving the
point estimate of the accumulation dates and the corresponding error.}
}}

\section{Subset}{

 \describe{
  \item{\code{x[[i]]}}{Extracts informations from a slot selected by
  subscript \code{i}. \code{i} is a length-one \code{\link{character}}
  vector. Returns the corresponding slot values.}
 }
}

\seealso{
Other class: 
\code{\link{BootCA-class}},
\code{\link{DiversityIndex}},
\code{\link{PermutationOrder-class}}
}
\author{
N. Frerebeau
}
\concept{class}
