% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{weightedGaussian}
\alias{weightedGaussian}
\title{Compute the spectral signature using Gaussian peaks.}
\usage{
weightedGaussian(location, scale, amplitude, wavelengths)
}
\arguments{
\item{location}{Vector of location parameters of the peaks (mean).}

\item{scale}{Vector of scale parameters of the peaks (standard deviation).}

\item{amplitude}{Vector of amplitudes of the peaks.}

\item{wavelengths}{Vector of wavenumbers at which to compute the function.}
}
\value{
The value of the Gaussian function at the given wavelengths.
}
\description{
Calculates the value of the squared exponential radial basis function at the given wavelengths,
given the parameters of the peaks. This function is thread-safe.
}
\examples{
  Cal_V <- seq(300,400,by=5)
  loc <- c(320,350,375)
  sca <- c(10,5,18)
  amp <- c(1000,5000,2000)
  weightedGaussian(loc,sca,amp,Cal_V)
}
