% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_continuous.R
\name{tree_continuous}
\alias{tree_continuous}
\title{Phylogenetic uncertainty - Trait Evolution Continuous Characters}
\usage{
tree_continuous(
  data,
  phy,
  n.tree = 10,
  model,
  bounds = list(),
  n.cores = NULL,
  track = TRUE,
  ...
)
}
\arguments{
\item{data}{Data vector for a single continuous trait, with names matching tips in \code{phy}.}

\item{phy}{Phylogenies (class 'multiPhylo', see ?\code{ape}).}

\item{n.tree}{Number of times to repeat the analysis with n different trees picked 
randomly in the multiPhylo file. If NULL, \code{n.tree} = 10}

\item{model}{The evolutionary model (see Details).}

\item{bounds}{settings to constrain parameter estimates. See \code{\link[geiger]{fitContinuous}}}

\item{n.cores}{number of cores to use. If 'NULL', number of cores is detected.}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{\link[geiger]{fitContinuous}}}
}
\value{
The function \code{tree_continuous} returns a list with the following
components:

\code{call}: The function call

\code{data}: The original full data vector

\code{sensi.estimates}:  (rate of evolution \code{sigsq}, 
root state \code{z0} and where applicable \code{optpar}),
AICc and the optimised value of the phylogenetic transformation parameter (e.g. \code{lambda}) 
for each analysis with a different phylogenetic tree.

\code{N.tree}: Number of trees \code{n.tree} analysed

\code{stats}: Main statistics for model parameters, i.e. minimum, maximum, mean, median and sd-values

\code{optpar}: Evolutionary model used (e.g. \code{lambda}, \code{kappa} etc.)
}
\description{
Fits models for trait evolution of continuous characters, 
evaluating phylogenetic uncertainty.
}
\details{
This function fits different models of continuous character evolution using \code{\link[geiger]{fitContinuous}}
to n trees, randomly picked in a multiPhylo file. 

Different evolutionary models from \code{fitContinuous} can be used, i.e. \code{BM},\code{OU},
\code{EB}, \code{trend}, \code{lambda}, \code{kappa}, \code{delta} and \code{drift}.

See \code{\link[geiger]{fitContinuous}} for more details on character models and tree transformations. 

Output can be visualised using \code{sensi_plot}.
}
\examples{
\dontshow{
#Load data:
data("primates")
#Model trait evolution accounting for phylogenetic uncertainty
adultMass<-primates$data$adultMass
names(adultMass)<-rownames(primates$data)
tree_cont<-tree_continuous(data = adultMass,phy = primates$phy,
model = "OU",n.tree=1,n.cores = 2,track = TRUE)
}
\dontrun{
#Load data:
data("primates")
#Model trait evolution accounting for phylogenetic uncertainty
adultMass<-primates$data$adultMass
names(adultMass)<-rownames(primates$data)
tree_cont<-tree_continuous(data = adultMass,phy = primates$phy,
model = "OU",n.tree=30,n.cores = 2,track = TRUE)
#Print summary statistics
summary(tree_cont)
sensi_plot(tree_cont)
sensi_plot(tree_cont,graphs="sigsq")
sensi_plot(tree_cont,graphs="optpar")
#Use a different evolutionary model 
tree_cont2<-tree_continuous(data = adultMass,phy = primates$phy,
model = "delta",n.tree=30,n.cores = 2,track = TRUE)
summary(tree_cont2)
sensi_plot(tree_cont2)
}
}
\references{
Paterno, G. B., Penone, C. Werner, G. D. A. 
\href{http://doi.wiley.com/10.1111/2041-210X.12990}{sensiPhy: 
An r-package for sensitivity analysis in phylogenetic 
comparative methods.} Methods in Ecology and Evolution 
2018, 9(6):1461-1467

Yang Z. 2006. Computational Molecular Evolution. Oxford University Press: Oxford. 

Harmon Luke J, Jason T Weir, Chad D Brock, Richard E Glor, and Wendell Challenger. 2008.
GEIGER: investigating evolutionary radiations. Bioinformatics 24:129-131.
}
\seealso{
\code{\link[geiger]{fitContinuous}}
}
\author{
Gijsbert Werner & Caterina Penone
}
