% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex_core_data.R
\name{bibtex_core_data}
\alias{bibtex_core_data}
\title{Makes a \code{bibtex} entry from an output of
\code{\link{abstract_retrieval}} or \code{\link{article_retrieval}}}
\usage{
bibtex_core_data(x)
}
\arguments{
\item{x}{output of \code{\link{abstract_retrieval}} or
\code{\link{article_retrieval}}, with both \code{get_statement}
and \code{content}}
}
\value{
A character vector of bibtex values
}
\description{
Makes a \code{bibtex} entry from an output of
\code{\link{abstract_retrieval}} or \code{\link{article_retrieval}}
}
\note{
Adapted from
\url{https://github.com/pybliometrics-dev/pybliometrics/blob/master/pybliometrics/scopus/abstract_retrieval.py}
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = abstract_retrieval("S1053811915002700", identifier = "pii",
   verbose = FALSE)
   res = bibtex_core_data(x)
   cat(res)
   x = abstract_retrieval("S1053811915002700", identifier = "pii",
   verbose = FALSE)
   res2 = bibtex_core_data(x)
   cat(res2)
}
}
