% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.fit.R
\name{rarefit}
\alias{rarefit}
\title{Fit the rare feature selection model}
\usage{
rarefit(y, X, A = NULL, Q = NULL, hc, intercept = T, lambda = NULL,
  alpha = NULL, nlam = 50, lam.min.ratio = 1e-04, nalpha = 10,
  rho = 0.01, eps1 = 1e-06, eps2 = 1e-05, maxite = 1e+06)
}
\arguments{
\item{y}{Length-\code{nobs} response variable.}

\item{X}{\code{nobs}-by-\code{nvars} input matrix:
each row is an observation vector and each column stores a count covariate.}

\item{A}{\code{nvars}-by-\code{nnodes} binary matrix encoding ancestor-descendant relationships
between leaves and tree nodes, where \code{nnodes} is the total number of tree nodes.
\code{A[i,j]} is 1 if the \code{i}th leaf is a descendant of the \code{j}th
node in the tree, and 0 otherwise. \code{A} should be in sparse matrix format
(inherit from class \code{\link[Matrix]{sparseMatrix}} as in package \code{Matrix}).
When \code{A} is \code{NULL}, the function will learn \code{A} from \code{hc}.}

\item{Q}{\code{(nvars+nnodes)}-by-\code{nnodes} matrix with columns forming an orthonormal
basis for the null space of \eqn{[I_nvars:-A]}. When \code{Q} is \code{NULL}, the function will learn
\code{Q} using the singular value decomposition.}

\item{hc}{An \code{hclust} tree of \code{nvars} leaves where each leaf corresponds
to a covariate. If the tree is not an \code{hclust} object, user needs to provide the matrix \code{A} instead.}

\item{intercept}{Whether intercept be fitted (default = TRUE) or set to zero (FALSE).}

\item{lambda}{A user-supplied \code{lambda} sequence. Typical usage is to
have the program compute its own \code{lambda} sequence based on
\code{nlam} and \code{lam.min.ratio}.}

\item{alpha}{A user-supplied \code{alpha} sequence. If letting the program
compute its own \code{alpha} sequence, a length-\code{nalpha} sequence of
equally-spaced \code{alpha} values between 0 and 1 will be used. In practice,
user may want to provide a more fine \code{alpha} sequence to tune
the model to its best performance (e.g., \code{alpha = c(1-exp(seq(0, log(1e-2), len = nalpha - 1)), 1)}).}

\item{nlam}{Number of \code{lambda} values (default = 50).}

\item{lam.min.ratio}{Smallest value for \code{lambda}, as a fraction of
\code{lambda.max} (i.e., the smallest value for which all coefficients are
zero). The default value is \code{1e-4}.}

\item{nalpha}{Number of \code{alpha} values (default = 10).}

\item{rho}{Penalty parameter for the quadratic penalty in the ADMM algorithm.
The default value is \code{1e-2}.}

\item{eps1}{Convergence threshold in terms of the absolute tolerance level
for the ADMMM algorithm. The default value is \code{1e-6}.}

\item{eps2}{Convergence threshold in terms of the relative tolerance level
for the ADMM algorithm. The default value is \code{1e-5}.}

\item{maxite}{Maximum number of passes over the data for every pair of
(\code{lambda}, \code{alpha}). The default value is \code{1e6}.}
}
\value{
Returns regression coefficients for \code{beta} and \code{gamma} and
intercept \code{beta0}. We use a \emph{matrix-nested-within-list} structure to store the coefficients: each list
item corresponds to an \code{alpha} value; matrix (or vector) in that list item stores
coefficients at various \code{lambda} values by columns (or entries).

\item{beta0}{Length-\code{nalpha} list with each item storing
intercept across various \code{lambda} in a vector: \code{beta0[[j]][i]}
is intercept fitted at (\code{lambda[i]}, \code{alpha[j]}).
If \code{intercept = FALSE}, \code{beta0} is \code{NULL}.}
\item{beta}{Length-\code{nalpha} list with each item storing
\code{beta} coefficient at various \code{lambda} in columns of a \code{nvars}-by-\code{nlam} matrix:
\code{beta[[j]][, i]} is \code{beta} coeffcient fitted at (\code{lambda[i]}, \code{alpha[j]}).}
\item{gamma}{Length-\code{nalpha} list with each item storing
\code{gamma} coefficient at various \code{lambda} in columns of a \code{nnodes}-by-\code{nlam} matrix:
\code{gamma[[j]][, i]} is \code{gamma} coeffcient vector fitted at (\code{lambda[i]}, \code{alpha[j]}).
If \code{alpha[j] = 0}, the problem becomes the lasso on \code{beta} and is solved
with \code{\link[glmnet]{glmnet}} on \code{beta}, in which case \code{gamma[[j]] = NA}.}
\item{lambda}{Sequence of \code{lambda} values used in model fit.}
\item{alpha}{Sequence of \code{alpha} values used in model fit.}
\item{A}{Binary matrix encoding ancestor-descendant relationship between leaves and nodes in the tree.}
\item{Q}{Matrix with columns forming an orthonormal basis for the null space of \eqn{[I_nvars:-A]}.}
\item{intercept}{Whether an intercept is included in model fit.}
}
\description{
Fit the rare feature selection model proposed in Yan and Bien (2018):
\deqn{min_{\beta, \gamma} 0.5 * ||y - X\beta - \beta_01_n||_2^2 +
\lambda * (\alpha * ||\gamma_{-root}||_1 + (1-\alpha) * ||\beta||_1)}
using an alternating direction method of multipliers (ADMM) algorithm
described in Algorithm 1 of the same paper.
The regularization path is computed over a two-dimensional grid of
regularization parameters: \code{lambda} and \code{alpha}. Of the two,
\code{lambda} controls the overall amount of regularization, and \code{alpha}
controls the tradeoff between sparsity and fusion of \eqn{\beta} (larger \code{alpha}
induces more fusion in \eqn{\beta}).
}
\details{
The function splits model fitting path by \code{alpha}. At each \code{alpha} value,
the model is fit on the entire sequence of \code{lambda} with warm start. We recommend
including an intercept (by setting \code{intercept=T}) unless the input data have been
centered.
}
\examples{
\dontrun{
# See vignette for more details.
set.seed(100)
ts <- sample(1:length(data.rating), 400) # Train set indices
# Fit the model on train set
ourfit <- rarefit(y = data.rating[ts], X = data.dtm[ts, ], hc = data.hc, lam.min.ratio = 1e-6,
                  nlam = 20, nalpha = 10, rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
}

}
\references{
Yan, X. and Bien, J. (2018) \emph{Rare Feature Selection in High Dimensions}, \url{https://arxiv.org/abs/1803.06675}.
}
\seealso{
\code{\link{rarefit.cv}}, \code{\link{rarefit.predict}}
}
