% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_depth_interactions.R
\name{plot_min_depth_interactions}
\alias{plot_min_depth_interactions}
\title{Plot the top mean conditional minimal depth}
\usage{
plot_min_depth_interactions(
  interactions_frame,
  k = 30,
  main = paste0("Mean minimal depth for ", paste0(k, " most frequent interactions"))
)
}
\arguments{
\item{interactions_frame}{A data frame produced by the min_depth_interactions() function or a randomForest object}

\item{k}{The number of best interactions to plot, if set to NULL then all plotted}

\item{main}{A string to be used as title of the plot}
}
\value{
A ggplot2 object
}
\description{
Plot the top mean conditional minimal depth
}
\examples{
forest <- randomForest::randomForest(Species ~ ., data = iris, ntree = 100)
plot_min_depth_interactions(min_depth_interactions(forest, c("Petal.Width", "Petal.Length")))

}
