% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remapcon.R
\name{remapcon}
\alias{remapcon}
\title{Conservative remapping}
\usage{
remapcon(x, y, z, xo, yo)
}
\arguments{
\item{x}{vector of input longitudes}

\item{y}{vector of input latitudes}

\item{z}{matrix of input data}

\item{xo}{vector of target longitudes}

\item{yo}{vector of target latitudes}
}
\value{
A remapped matrix of dimensions \code{c(length(xo), length(yo))}
}
\description{
Implements conservative remapping, weighting with
the overlap area between pixels.
}
\examples{
z <- 1:(31*51)
dim(z) <- c(31, 51)
x <- seq(4, 10, 0.2)
y <- seq(30, 40, 0.2)
xo <- seq(5, 6, 0.5)
yo <- seq(35, 37, 0.5)
zo <- remapcon(x, y, z, xo, yo)
zo
#       [,1]  [,2]  [,3]   [,4]   [,5]
# [1,] 781.0 858.5 936.0 1013.5 1091.0
# [2,] 783.5 861.0 938.5 1016.0 1093.5
# [3,] 786.0 863.5 941.0 1018.5 1096.0
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
