% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_functions.R
\name{surv.range}
\alias{surv.range}
\title{Evaluate whether times are in an interval}
\usage{
surv.range(survi, tl, tu)
}
\arguments{
\item{survi}{a \code{survfit} object.}

\item{tl}{the lower bound.}

\item{tu}{the upper bound.}
}
\value{
A boolean vector.
}
\description{
\code{surv.range} evaluates \code{survfit} object survival times by upper and lower bounds.
}
\examples{
library(survival)
fit <- survfit(Surv(stop, event) ~ 1, data=bladder)
summary(fit)
surv.range(fit, .1, .9)

}
\keyword{internal}
