% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{toEnuAdp}
\alias{toEnuAdp}
\title{Convert an ADP Object to ENU Coordinates}
\usage{
toEnuAdp(x, declination = 0, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an \linkS4class{adp} object.}

\item{declination}{magnetic declination to be added to the heading, to get
ENU with N as "true" north.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Convert an ADP Object to ENU Coordinates
}
\references{
\url{https://www.nortekgroup.com/faq/how-is-a-coordinate-transformation-done}
}
\seealso{
See \code{\link[=read.adp]{read.adp()}} for notes on functions relating to
\code{"adp"} objects.  Also, see \code{\link[=beamToXyzAdp]{beamToXyzAdp()}} and
\code{\link[=xyzToEnuAdp]{xyzToEnuAdp()}}.

Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpEnsembleAverage}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley
}
\concept{things related to adp data}
