% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFE.R
\name{calcFE}
\alias{calcFE}
\title{Calculates founder Equivalents}
\usage{
calcFE(ped)
}
\arguments{
\item{ped}{the pedigree information in datatable format.  Pedigree
(req. fields: id, sire, dam, gen, population).}
}
\value{
The founder equivalents \code{FE = 1 / sum(p ^ 2)}, where \code{p}
is average number of descendants and \code{r} is the mean number of founder
alleles retained in the gene dropping experiment.
}
\description{
Part of the Genetic Value Analysis
}
\details{
It is assumed that the pedigree has no partial parentage
}
\examples{
\donttest{
## Example from Analysis of Founder Representation in Pedigrees: Founder
## Equivalents and Founder Genome Equivalents.
## Zoo Biology 8:111-123, (1989) by Robert C. Lacy
library(nprcgenekeepr)
ped <- data.frame(
id = c("A", "B", "C", "D", "E", "F", "G"),
sire = c(NA, NA, "A", "A", NA, "D", "D"),
dam = c(NA, NA, "B", "B", NA, "E", "E"),
stringsAsFactors = FALSE
)
ped["gen"] <- findGeneration(ped$id, ped$sire, ped$dam)
ped$population <- getGVPopulation(ped, NULL)
pedFactors <- data.frame(
  id = c("A", "B", "C", "D", "E", "F", "G"),
  sire = c(NA, NA, "A", "A", NA, "D", "D"),
  dam = c(NA, NA, "B", "B", NA, "E", "E"),
  stringsAsFactors = TRUE
)
pedFactors["gen"] <- findGeneration(pedFactors$id, pedFactors$sire,
                                    pedFactors$dam)
pedFactors$population <- getGVPopulation(pedFactors, NULL)
fe <- calcFE(ped)
feFactors <- calcFE(pedFactors)
}

}
