% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npStochinUnpaired.R
\name{npStochinUnpaired}
\alias{npStochinUnpaired}
\title{A test of a stochastic inequality given two independent samples}
\usage{
npStochinUnpaired(x1, x2, d = 0, alternative = "two.sided",
  iterations = 5000, alpha = 0.05, epsilon = 1 * 10^(-6),
  ignoreNA = FALSE, max.iterations = 100000)
}
\arguments{
\item{x1, x2}{the (non-empty) numerical data vectors which contain the
variables to be tested.}

\item{d}{the maximal difference in probabilities assumed \eqn{H_0 : P(X_2 >
X_1) - P(X_2 < X_1) <= d}. Default is 0.}

\item{alternative}{a character string describing the alternative
hypothesis. Default is "greater". If "less" is given, \code{x1} and
\code{x2} are switched for each other.}

\item{iterations}{the number of iterations used, should not be changed if
the exact solution should be derived.}

\item{alpha}{the type I error.}

\item{epsilon}{the tolerance in terms of probability of the Monte Carlo
simulations.}

\item{ignoreNA}{if \code{TRUE}, NA values will be omitted. Default:
\code{FALSE}}

\item{max.iterations}{the maximum number of iterations that should be
carried out. This number could be increased to achieve greater accuracy in
cases where the difference between the threshold probability and theta is
small. Default: \code{10000}}
}
\value{
A list with class "nphtest" containing the following components:

\item{method}{ a character string indicating the name and type of the test
that was performed.  } \item{data.name}{ a character string giving the
name(s) of the data.  } \item{alternative}{ a character string describing
the alternative hypothesis.  } \item{estimate}{ an estimate of \eqn{P(x_2 >
x_1) - P(x_2 < x_1)}.  } \item{probrej}{ numerical estimate of the
rejection probability of the randomized test, derived by taking an average
of \code{iterations} realizations of the rejection probability.  }
\item{bounds}{ the lower and upper bounds of the variables.  }
\item{null.value}{ the specified hypothesized value of the correlation
between the variables.  } \item{alpha}{ the type I error.  } \item{theta}{
the parameter that minimizes the type II error.  } \item{pseudoalpha}{
\code{theta}*\code{alpha}, this is the level used when calculating the
average rejection probability during the iterations.  } \item{rejection}{
logical indicator for whether or not the null hypothesis can be rejected.
} \item{iterations}{ the number of iterations that were performed.  }
}
\description{
The data input consists of a sequence of independent realizations
observations of each random variable, observations of the different
sequences also being independent.
}
\details{
Given \eqn{-1 < d < 1} it is a test of the null hypothesis \eqn{H_0 : P(X_2
> X_1) \le P(X_2 < X_1) + d} against the alternative hypothesis \eqn{H_1 :
P(X_2 > X_1) > P(X_2 < X_1) + d}.

The data is randomly matched into pairs and then treats them as matched
pairs. The number of pairs is equal to the number of observations in the
smaller sequence. The exact randomized test is then used to determine if
sufficiently many occurrences of \eqn{x_2 > x_1} occur when compared to how
often \eqn{x_2 < x_1} occurs, using level \code{theta}*\code{alpha}. The
matching into pairs is repeated \code{iterations} times. The test gives a
rejection of the average rejection probability in these iterations lies
above \code{theta}. If the average rejection probability lies too close to
theta then the number of iterations is increased.

\code{theta} is determined to maximize the set of differences
\eqn{P(X_2>X_1) - P(X_2<X_1)} belonging to the alternative hypothesis in
which the type II error probability lies below 0.5. For more details see
the paper.
}
\examples{

data(french)
origin <- french$french.origin
rest <- french$rest.of.civil
npStochinUnpaired(origin, rest, ignoreNA = TRUE)

}
\references{
Schlag, Karl H. 2008, A New Method for Constructing Exact Tests
without Making any Assumptions, Department of Economics and Business
Working Paper 1109, Universitat Pompeu Fabra. Available at
\url{https://ideas.repec.org/p/upf/upfgen/1109.html}.
}
\seealso{
\url{https://homepage.univie.ac.at/karl.schlag/statistics.php}
}
\author{
Karl Schlag, Peter Saffert and Oliver Reiter
}
\keyword{data}
\keyword{inequality}
\keyword{stochastic}
\keyword{unpaired}
