% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_sparse_model}
\alias{make_sparse_model}
\title{Generate sparse linear model and random samples}
\usage{
make_sparse_model(n, p, alpha, rho, snr, nsim)
}
\arguments{
\item{n}{the sample size}

\item{p}{the number of features}

\item{alpha}{sparsity, i.e., \eqn{n^\alpha} nonzeros in the true regression coefficient.}

\item{rho}{pairwise correlation among features}

\item{snr}{signal to noise ratio, defined as \eqn{\beta^T \Sigma \beta / \sigma^2}}

\item{nsim}{the number of simulations}
}
\value{
A list object containing: \describe{
\item{\code{x}: }{The \code{n} by \code{p} design matrix}
\item{\code{y}: }{The \code{n} by \code{nsim} matrix of response vector, each column representing one replication of the simulation}
\item{\code{beta}: }{The true regression coefficient vector}
\item{\code{sigma}: }{The true error standard deviation}}
}
\description{
Generate design matrix and response following linear models
\eqn{y = X \beta + \epsilon}, where
\eqn{\epsilon ~ N(0, \sigma^2)}, and \eqn{X ~ N(0, \Sigma)}.
}
