% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pgls}
\alias{pgls}
\title{Penalized Generalized Lomb-Scargle}
\usage{
pgls(lclist, period_min = NULL, period_max = NULL, periods = NULL,
  gamma1 = 0, gamma2 = 20, at = rep(1, length(lclist)), LS_flag = TRUE,
  sol_ls = NULL, BCD_flag = TRUE, fast_BCD_flag = TRUE, max_iter = 100,
  tol = 1e-04, mm_iter = 5, verbose = FALSE)
}
\arguments{
\item{lclist}{list of lightcurve data frames}

\item{period_min}{minimum period}

\item{period_max}{maximum period}

\item{periods}{grid of periods}

\item{gamma1}{vector of Amplitude regularization parameter}

\item{gamma2}{vector of Phase regularization parameter}

\item{at}{amplitude prior parameter}

\item{LS_flag}{boolean whether to run Lomb-Scargle algorithm}

\item{sol_ls}{Lomb-Scargle solution, used if LS_flag=FALSE}

\item{BCD_flag}{boolean whether to run bcd algorithm}

\item{fast_BCD_flag}{boolean whether to run BCD on relevant subset of periods}

\item{max_iter}{maximum number of outer iterations - passed to bcd_inexact}

\item{tol}{tolerance on relative change in loss - passed to bcd_inexact}

\item{mm_iter}{number of MM iterations for rho update - passed to bcd_inexact}

\item{verbose}{boolean whether to print progress}
}
\description{
\code{pgls} estimates periods for a collection of lightcurves sampled over multiple bands.
It borrows strength across multiple bands via shrinkage penalties on amplitudes an phases.
}
\examples{
period_min <- 3.5
period_max <- 3.65
out <- pgls(cepii,period_min=period_min,period_max=period_max)
out$best_fitBCD
}

