% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapro.R
\name{ordmeta}
\alias{ordmeta}
\title{ordmeta}
\usage{
ordmeta(p, is.onetail = TRUE, eff.sign = NULL)
}
\arguments{
\item{p}{A vector of p-values}

\item{is.onetail}{Logical. If set TRUE, p-values are combined without considering the direction of effect, and vice versa. Default: TRUE.}

\item{eff.sign}{A vector of signs of effect sizes. It works when is.onetail = FALSE}
}
\value{
A list of combined p-value (p), optimal rank where minimum marginal p-value exists (optimal_rank), index of effective p-values (eff.p.idx) and minimum marginal p-value (MMP) if is.onatail=TRUE. Otherwise, the direction of combined effects (overall.eff.direction) is added.
}
\description{
Minimum Marginal P-value in joint order distribution
}
\examples{
\donttest{ordmeta(p=c(0.01, 0.02, 0.8, 0.25), is.onetail=FALSE, eff.sign = c(1,1,1,-1))}
}
