# --------------------------------------------------------------------------------
# title: Linkspotter/createShinyAppFolder
# description: function to load and properly proccess a file
# author: Alassane Samba (alassane.samba@orange.com)
# Copyright (c) 2017 Alassane Samba, Orange
# ---------------------------------------------------------------------------------
#
#' @title Ready-for-deployment shiny app folder creation
#' @description  This function creates a shiny app folder containing a shiny app object directly readable by a shiny-server.
#'
#' @param linkspotterObject a linkspotter object, resulting from linkspotterComplete() or linkspotterOnFile() functions.
#' @param folderName a character string corresponding to the name of the shiny app folder to create.
#'
#' @examples
#' data(iris)
#' lsOutputIris<-linkspotterComplete(iris)
#' tmpShinyFolder<-tempdir()
#' createShinyAppFolder(lsOutputIris,
#' folderName=file.path(tmpShinyFolder,"myIrisLinkspotterShinyApp1")
#' )
#' \dontrun{
#' # launch the shiny app
#' shiny::runApp(tmpShinyFolder)
#' }
#' @export
createShinyAppFolder<-function(linkspotterObject, folderName){
  #linkspotterShinyAppObject<-linkspotterObject$launchShiny()
  dir.create(folderName, recursive = T)
  dir.create(file.path(folderName, 'src'), showWarnings = FALSE)
  outputFileName=file.path(file.path(folderName, 'src'),"linkspotterObject.rdata")
  save(linkspotterObject,file = outputFileName)
  write("# Shiny app file generated by Linkspotter (http://linkspotter.sigmant.net) ",file = file.path(folderName,"app.r"),append = T)
  write("load('./src/linkspotterObject.rdata')",file = file.path(folderName,"app.r"),append = T)
  write("library(linkspotter)",file = file.path(folderName,"app.r"),append = T)
  write("linkspotterShinyAppObject<-linkspotterObject$launchShiny()",file = file.path(folderName,"app.r"),append = T)
  write("linkspotterShinyAppObject",file = file.path(folderName,"app.r"),append = T)
}
