% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot_scheme}
\alias{plot_map}
\title{Plot Colour Scheme}
\usage{
plot_scheme(x, colours = FALSE, names = FALSE, size = 1)

plot_map(x)
}
\arguments{
\item{x}{A \code{\link{character}} vector of colours.}

\item{colours}{A \code{\link{logical}} scalar: should the hexadecimal
representation of the colours be displayed?}

\item{names}{A \code{\link{logical}} scalar: should the name of the colours
be displayed?}

\item{size}{A \code{\link{numeric}} value giving the amount by which
plotting text should be magnified relative to the default.
Works the same as \code{cex} parameter of \code{\link[graphics]{par}}.}
}
\description{
\code{plot_scheme} shows colours in a plot.
}
\details{
\code{plot_map} produces a diagnostic map for a given colour scheme.
}
\examples{
## Plot colour schemes
plot_scheme(colour("bright")(7))
plot_scheme(colour("sunset")(11))
plot_scheme(colour("YlOrBr")(9))
plot_scheme(colour("discrete rainbow")(14))

## Plot diagnostic maps
plot_map(colour("bright")(7))
plot_map(colour("sunset")(11))
plot_map(colour("YlOrBr")(9))
plot_map(colour("discrete rainbow")(14))
}
\seealso{
Other diagnostic tools: \code{\link{convert}}
}
\author{
N. Frerebeau
}
\concept{diagnostic tools}
