% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_repr.R
\name{ip_to_binary}
\alias{ip_to_binary}
\alias{binary_to_ip}
\title{Represent address as binary}
\usage{
ip_to_binary(x)

binary_to_ip(x)
}
\arguments{
\item{x}{\itemize{
\item For \code{ip_to_binary()}: An \code{\link{ip_address}} vector
\item For \code{binary_to_ip()}: A character vector containing only \code{0} and \code{1} characters
}}
}
\value{
\itemize{
\item For \code{ip_to_binary()}: A character vector
\item For \code{binary_to_ip()}: An \code{\link{ip_address}} vector
}
}
\description{
Encode or decode an \code{\link{ip_address}} as a binary bit string.
}
\details{
The bits are stored in network order (also known as big-endian order), which
is part of the IP standard.

IPv4 addresses use 32 bits, IPv6 addresses use 128 bits, and missing values
are encoded as \code{NA}.
}
\examples{
x <- ip_address(c("192.168.0.1", "2001:db8::8a2e:370:7334", NA))
ip_to_binary(x)

binary_to_ip(ip_to_binary(x))
}
\seealso{
\itemize{
\item \code{\link[=ip_to_integer]{ip_to_integer()}} and \code{\link[=integer_to_ip]{integer_to_ip()}}
\item \code{\link[=ip_to_bytes]{ip_to_bytes()}} and \code{\link[=bytes_to_ip]{bytes_to_ip()}}
}
}
