% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/andrewsProjection.R
\name{andrewsProjection}
\alias{andrewsProjection}
\title{Use Andrews plots to visualize the Hilbert curve}
\usage{
andrewsProjection(x, breaks = 30)
}
\arguments{
\item{x}{a matrix of counts, where rows correspond to samples and columns to Hilbert index}

\item{breaks}{the number of points used to display the Andrews curve}
}
\value{
a list with 2 items:
\itemize{
    \item freq : a matrix with \code{breaks} rows and \code{ncol(x)} columns containing the Andrews vector for projection
    \item i : a vector with \code{breaks} elements corresponding to the Andrews indices
}
}
\description{
Use a Fourier series to project the Hilbert curve, based on the number of points
per Hilbert index. See \href{https://en.wikipedia.org/wiki/Andrews_plot}{Wikipedia - Andrews plot}
for a description of the method.
}
\details{
The Andrews curve corresponds to a projection of each item to \eqn{(1/2^0.5,sin(t),cos(t),sin(2t),cos(2t),...)} where
\emph{t} (the Andrews index) varies between \eqn{-\pi} and \eqn{\pi}.
}
\examples{
# generate a random matrix
ncols <- 5
mat <- matrix(rnorm(ncols*1000),ncol=ncols)
dimnames(mat)[[2]] <- LETTERS[seq(ncols)]

# generate categories
conditions <- sample(letters[1:3],nrow(mat),replace = TRUE)
# generate 4 bins with a minimum bin size of 5
horder <- 4
cuts <- make.cut(mat,n=horder+1,count.lim=5)
# Generate the cuts and compute the Hilbert index
cut.mat <- do.cut(mat,cuts,type='fixed')
hc <- do.hilbert(cut.mat,horder)
# compute hilbert index per condition
condition.mat <- table(conditions,hc)
condition.pc <- apply(condition.mat,1,function(x) x/sum(x))
condition.pc <- t(condition.pc)
# project the matrix to the Andrews curve
av <- andrewsProjection(condition.pc)
proj <- condition.pc \%*\% t(av$freq)

plot(range(av$i),
     range(proj),
     type='n',
     xlab='Andrews index',
     ylab='Projection')
for(i in seq(nrow(proj))) {
    lines(av$i,
          proj[i,],
          col=i)
}
legend('bottomleft',
       legend=letters[1:3],
       col=seq(1,3),
       pch=16,
       bty='n')
}
\author{
Yann Abraham
}
