% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{strat_end}
\alias{strat_end}
\title{Adjust a subspace stratified design at the end of the study.}
\usage{
strat_end(interim, sub_stagetwo)
}
\arguments{
\item{interim}{A preliminary stratified design adjusted at interim as returned by \code{strat_interim()}.}

\item{sub_stagetwo}{The subtypes observed for the patients accrued in stage 2.}
}
\value{
A list returning the arguments of the function and the final design of the stratified trial.
}
\description{
Adjust a subspace stratified design at the end of the study.
}
\examples{
p0_sub <- c(0.1, 0.3, 0.5)
p1_sub <- c(0.3, 0.5, 0.7)
distr_sub <- c(1/3, 1/3, 1/3)
start <- strat_start(p0_sub, p1_sub, distr_sub)
n1 <- start$des_start[2]
subone <- sample(c(1,2,3), n1, TRUE)
interim <- strat_interim(start, subone)
n2 <- interim$des_interim[4]
subtwo <- sample(c(1,2,3), n2, TRUE)
strat_end(interim, subtwo)
}
