% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gran_advice.R
\name{gran_advice}
\alias{gran_advice}
\title{Advice summaries for granularities}
\usage{
gran_advice(.data, gran1, gran2, hierarchy_tbl = NULL, ...)
}
\arguments{
\item{.data}{a tsibble.}

\item{gran1, gran2}{granularities.}

\item{hierarchy_tbl}{A hierarchy table specifying the hierarchy of units and their relationships.}

\item{...}{other arguments to be passed for appropriate labels.}
}
\value{
Summary check points before visualizing distribution across bivariate granularities
}
\description{
Recommendations on plot choices, interaction, number of observations and intra or inter facet homogeneity. Important summaries before drawing distribution plots.
}
\examples{
library(dplyr)
library(ggplot2)

smart_meter10 \%>\%
filter(customer_id == "10017936") \%>\%
  gran_advice(gran1 = "wknd_wday",
            gran2 = "hour_day")

# choosing quantile plots from plot choices
smart_meter10 \%>\%
filter(customer_id == "10017936") \%>\%
  prob_plot(
    gran1 = "wknd_wday",
    gran2 = "hour_day",
    response = "general_supply_kwh",
    plot_type = "quantile",
    quantile_prob = c(0.1, 0.25, 0.5, 0.75, 0.9)
  ) +
  scale_y_sqrt()

}
