% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{buildAncDesTotalDF}
\alias{buildAncDesTotalDF}
\title{Returns data frame with plot coordinates of all ancestors and descendants of a variety.}
\usage{
buildAncDesTotalDF(v1, geneal, mAnc = 3, mDes = 3)
}
\arguments{
\item{v1}{the label of the vertex of interest (in character string format)}

\item{geneal}{the full genealogy (in data frame format)}

\item{mAnc}{the maximum number of generations of ancestors of v1 to be displayed (in numeric format)}

\item{mDes}{the maximum number of generations of descendants of v1 to be displayed (in numeric format)}
}
\description{
Returns the data frame that includes labels and plot coordinates of all ancestors and descendants of a variety. Users can specify the maximum number of ancestors and descendants to display.
}
\examples{
data(sbGeneal)
v1 <- "Essex"
buildAncDesTotalDF(v1, sbGeneal)
}
\references{
Rutter L, VanderPlas S, Cook D, Graham MA (2019).
ggenealogy: An R Package for Visualizing Genealogical Data.
\emph{Journal of Statistical Software},
\bold{89}(13), 1--31.
\doi{10.18637/jss.v089.i13}
}
\seealso{
\code{\link{buildAncList}} for information on determining ancestors

\code{\link{buildDesList}} for information on determining descendants
}
