% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{LogLogistic}
\alias{LogLogistic}
\title{Log-logistic Curve constructor function}
\usage{
LogLogistic(theta, eta)
}
\arguments{
\item{theta}{Scale parameter for Log-logistic distribution.}

\item{eta}{Shape parameter for Log-logistic distribution.}
}
\description{
This creates a Curve object for a Log-logistic distribution.\cr
Curve objects contain all necessary information to describe a distribution, including functions and parameters describing it.\cr
See Details for information on parameterisation.
}
\details{
The log-logistic distribution has parameterisation:\cr
f(x) = eta (theta^beta) x^(eta-1) (theta^eta + x^eta)^-2\cr
F(x) = (x^eta) /(theta^eta+x^eta)
}
\examples{
LogLogistic(theta=20,eta=2)
}
\author{
Jasmin Ruehl
}
