% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geer.R
\name{modular}
\alias{modular}
\alias{ldFormula}
\alias{optimizeGeer}
\alias{mkGeerMod}
\title{Modular Functions for GEE-MCD and WGEE-MCD Fits}
\usage{
ldFormula(formula, data = NULL, triple = c(3, 3, 3), method = c("gee-mcd",
  "wgee-mcd"), corr.struct = c("id", "cs", "ar1"), rho = 0.5,
  ipw.order = 1, weights.vec = NULL, control = geerControl(),
  start = NULL)

optimizeGeer(m, Y, X, Z, W, H, time, method, corr.struct, rho, ipw.order,
  control, start)

mkGeerMod(opt, args, triple, rho, corr.struct, mc)
}
\arguments{
\item{formula}{a two-sided linear formula object describing the covariates
for both the mean and covariance matrix part of the model, with the
response, the corresponding subject id and measurement time on the left of
a operator~, divided by vertical bars ("|").}

\item{data}{a data frame containing the variables named in formula.}

\item{triple}{an integer vector of length three containing the degrees of the
three polynomial functions for the mean structure, the log innovation
-variances and the autoregressive coefficients.}

\item{method}{choose 'gee-mcd' (Ye and Pan, 2006) or 'wgee-mcd' (Pan et al.
2012).}

\item{corr.struct}{choose 'id' (independent), 'cs' (compound symmetry) or
'ar1' (AR(1)).}

\item{rho}{a parameter used in the 'working' covariance structure.}

\item{ipw.order}{the order for MAR remaining model.}

\item{weights.vec}{a user specified vector for the weights H in WGEE-MCD.}

\item{control}{a list (of correct class, resulting from geerControl())
containing control parameters, see the *geerControl documentation for
details.}

\item{start}{starting values for the parameters in the model.}

\item{m}{an integer vector of number of measurements for each subject.}

\item{Y}{a vector of responses for all subjects.}

\item{X}{model matrix for mean structure model.}

\item{Z}{model matrix for the diagonal matrix.}

\item{W}{model matrix for the lower triangular matrix.}

\item{H}{a vector of weights used in WGEE-MCD.}

\item{time}{a vector of time from the data.}

\item{opt}{optimized results returned by optimizeGeer.}

\item{args}{arguments returned by ldFormula.}

\item{mc}{matched call from the calling function.}
}
\description{
Modular Functions for a modified Cholesky decomposition (MCD)
  based (weighted) generalised estimating equations (GEE/WGEE) fits
}
