% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period2.R
\name{analyze.p2}
\alias{analyze.p2}
\title{Apply Period 2 Analysis}
\usage{
analyze.p2(per1, per2, opt.cov)
}
\arguments{
\item{per1}{A dataframe containing the period 1 data.}

\item{per2}{A dataframe containing the period 2 data.}

\item{opt.cov}{A character vector indicating the optimal set of variables
(obtained from the period 1 analysis).}
}
\value{
The function returns a list of the following datasets. \describe{
  \item{\code{pred.REF}}{A dataframe including the period 2 prediction for
  the REF turbine.} \item{\code{pred.CTR}}{A dataframe including the period 2
  prediction for the CTR-b turbine.} }
}
\description{
Conducts period 2 analysis; uses the optimal set of variables obtained in the
period 1 analysis to predict the power output of REF and CTR-b turbines in
period 2.
}
\examples{
df.ref <- with(wtg, data.frame(time = time, turb.id = 1, wind.dir = D,
 power = y, air.dens = rho))
df.ctrb <- with(wtg, data.frame(time = time, turb.id = 2, wind.spd = V,
 power = y))
df.ctrn <- df.ctrb
df.ctrn$turb.id <- 3

data <- arrange.data(df.ref, df.ctrb, df.ctrn, p1.beg = '2014-10-24',
 p1.end = '2014-10-25', p2.beg = '2014-10-25', p2.end = '2014-10-26',
 k.fold = 2)

p1.res <- analyze.p1(data$train, data$test, ratedPW = 1000)
p2.res <- analyze.p2(data$per1, data$per2, p1.res$opt.cov)

}
\references{
H. Hwangbo, Y. Ding, and D. Cabezon, 'Machine Learning Based
  Analysis and Quantification of Potential Power Gain from Passive Device
  Installation,' arXiv:1906.05776 [stat.AP], Jun. 2019.
  \url{https://arxiv.org/abs/1906.05776}.
}
