% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotParkesGrid}
\alias{plotParkesGrid}
\title{Plot a Parkes (Consensus) Error Grid}
\usage{
plotParkesGrid(referenceVals, testVals, type = 1, title = "", xlab = "",
  ylab = "", linesize = 0.5, linetype = "solid", linecolor = "black",
  linealpha = 0.6, pointsize = 2, pointalpha = 1, zones = NA,
  unit = "gram")
}
\arguments{
\item{referenceVals}{A vector of glucose values obtained via the reference
method.}

\item{testVals}{A vector of glucose values obtained via a non-reference
method (e.g. a new meter). The values in this vector are paired with those
in \code{referenceVals}, so the length should be the same.}

\item{type}{An integer (1 or 2) specifying whether to plot the grid for Type 1
or Type 2 diabetes. Defaults to 1.}

\item{title}{The main plot title. Defaults to "Parkes (Consensus) Error Grid
for Type [type] Diabetes".}

\item{xlab}{The x-axis label. Defaults to "Reference Glucose
Concentration (mg/dL)".}

\item{ylab}{The y-axis label. Defaults to "Test Glucose Concentration
(mg/dL)".}

\item{linesize}{The size to be used when drawing the zone lines. The
acceptable values are the same as for \code{\link[ggplot2]{geom_segment}}.
The default is 0.5.}

\item{linetype}{The type of line to be used when drawing the zone lines. The
acceptable values are the same as for \code{\link[ggplot2]{geom_segment}}.
The default is "solid".}

\item{linecolor}{The color of the zone lines. The acceptable values are the
same as for \code{\link[ggplot2]{geom_segment}}.
The default is "black".}

\item{linealpha}{The alpha (transparency) level to be used when drawing
the zone lines. The acceptable values are the same as for
\code{\link[ggplot2]{geom_segment}}. The default is 0.6.}

\item{pointsize}{The size to be used when plotting the glucose data points.
The acceptable values are the same as for \code{\link[ggplot2]{geom_point}}.
The default is 2.}

\item{pointalpha}{The alpha (transparency) level to be used when plotting
the glucose data points. The acceptable values are the same as for
\code{\link[ggplot2]{geom_point}}. The default is 1.}

\item{zones}{An optional character vector specifying the Clarke zones
for each paired value. If this is not supplied, \code{\link{getClarkeZones}}
will be called to generate zone labels.}

\item{unit}{A string specifying the units of measurement. This should be either
\code{"gram"} (the default) for \code{mg/dl} or \code{"mol"} for \code{mmol/l}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object is returned. If the return
value is not assigned, a plot is drawn.
}
\description{
The function uses \code{\link[ggplot2]{ggplot}} to draw the
Parkes (consensus) error grid lines according to the criteria described in
the publications listed in the References section (see below). If zones
have not already been assigned via the \code{zones} parameter, the
function \code{\link{getParkesZones}} is called first. The values in
\code{referenceVals} and \code{testVals} are then superimposed as a scatter
plot. Some basic plot parameters can be specified as arguments, but the
return value can also be stored and modified further before plotting
(see examples and vignette).
}
\examples{
library(ggplot2)

# default
plotParkesGrid(glucose_data$ref, glucose_data$test)

# with options
plotParkesGrid(glucose_data$ref, glucose_data$test,
              pointsize=2,
              pointalpha=0.5,
              linesize=2,
              linealpha=0.3,
              linetype="dotdash")

# store return value and modify
peg <- plotParkesGrid(glucose_data$ref, glucose_data$test, type=2)

peg + theme_gray() +
   theme(plot.title = element_text(size = rel(2), colour = "red"))
}
\references{
Parkes, J. L., S. L. Slatin, S. Pardo, and B.H. Ginsberg. "A New Consensus
Error Grid to Evaluate the Clinical Significance of Inaccuracies in the
Measurement of Blood Glucose." Diabetes Care 23, no. 8 (August 2000):
1143-48

Pfutzner, Andreas, David C. Klonoff, Scott Pardo, and Joan L. Parkes.
"Technical Aspects of the Parkes Error Grid." Journal of Diabetes Science
and Technology 7, no. 5 (September 2013): 1275-81
}
\seealso{
\code{\link{getParkesZones}} \code{\link[ggplot2]{ggplot}}
}

