% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_exposure.R
\name{sim_baseline}
\alias{sim_baseline}
\title{Expected baseline health outcomes}
\usage{
sim_baseline(n, lambda, trend = "no trend", slope = 1, amp = 0.6,
  start.date = "2000-01-01")
}
\arguments{
\item{n}{A numeric value specifying the number of days for which to simulate
data}

\item{lambda}{A numeric value specifying the mean for the expected outcomes}

\item{trend}{A character string that specifies the desired trend function.
Options are:
\itemize{
  \item{"no trend": No trend, either seasonal or long-term (default).}
  \item{"cos1": A seasonal trend only.}
  \item{"cos2": A seasonal trend with variable amplitude across years.}
  \item{"cos3": A seasonal trend with steadily decreasing amplitude over time.}
  \item{"linear": A linear long-term trend with no seasonal trend.}
  \item{"curvilinear": A curved long-term trend with no seasonal trend.}
  \item{"cos1linear": A seasonal trend plus a linear long-term trend.}
  }
See the package vignette for examples of the shapes of these trends.}

\item{slope}{A numeric value specifying the slope of the trend, to be used
with \code{trend = "linear"} or \code{trend = "cos1linear"}.}

\item{amp}{A numeric value specifying the amplitude of the seasonal trend.
Must be between -1 and 1.}

\item{start.date}{A date in the format "yyyy-mm-dd" specifying the first day
for which to simulate data}
}
\value{
A data frame with the date and expected baseline outcome count for each
   day of simulated data.
}
\description{
Generates expected baseline health outcome counts based on average outcome and
desired seasonal and / or long-term trends.
}
\examples{
sim_baseline(n = 5, lambda = 100, trend = "cos1")

}
