% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma.R
\name{gamma}
\alias{gamma}
\alias{mgamma}
\title{The Gamma distribution}
\usage{
mgamma(
  r = 0,
  truncation = 0,
  shape = 2,
  rate = 1,
  scale = 1/rate,
  lower.tail = TRUE
)
}
\arguments{
\item{r}{rth raw moment of the distribution, defaults to 1.}

\item{truncation}{lower truncation parameter, defaults to 0.}

\item{shape, rate, scale}{shape, rate and scale of the distribution with default values of 2 and 1 respectively.}

\item{lower.tail}{logical; if TRUE (default), moments are \eqn{E[x^r|X \le y]}, otherwise, \eqn{E[x^r|X > y]}}
}
\value{
Provides the truncated rth raw moment of the distribution.

 ## The zeroth truncated moment is equivalent to the probability function
 pgamma(2,shape=2,rate=1)
 mgamma(truncation=2)

 ## The (truncated) first moment is equivalent to the mean of a (truncated) random sample,
 #for large enough samples.
 x = rgamma(1e5,shape=2,rate=1)
 mean(x)
 mgamma(r=1,lower.tail=FALSE)

 sum(x[x>quantile(x,0.1)])/length(x)
 mgamma(r=1,truncation=quantile(x,0.1),lower.tail=FALSE)
}
\description{
Raw moments for the Gamma distribution.
}
\details{
Probability and Cumulative Distribution Function:

 \deqn{f(x) = \frac{1}{s^k\Gamma(k)}\omega^{k-1}e^{-\frac{\omega}{s}},\qquad F_X(x) = \frac{1}{\Gamma(k)}\gamma(k,\frac{\omega}{s})},

 where \eqn{\Gamma(x)} stands for the upper incomplete gamma function function, while \eqn{\gamma(s,x)} stands for the lower incomplete Gamma function with upper bound \eqn{x}.

 The y-bounded r-th raw moment of the distribution equals:

 \deqn{\mu^r_y =   \frac{s^{r}}{\Gamma(k)} \Gamma\left(r + k , \frac{y}{s} \right)  }
}
