% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniform.R
\name{random.Uniform}
\alias{random.Uniform}
\title{Draw a random sample from a continuous Uniform distribution}
\usage{
\method{random}{Uniform}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{Uniform} object created by a call to \code{\link[=Uniform]{Uniform()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector containing values in \code{[a, b]} of length \code{n}.
}
\description{
Draw a random sample from a continuous Uniform distribution
}
\examples{

set.seed(27)

X <- Uniform(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))

}
