% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{quantile.Weibull}
\alias{quantile.Weibull}
\title{Determine quantiles of a Weibull distribution}
\usage{
\method{quantile}{Weibull}(d, p, ...)
}
\arguments{
\item{d}{A \code{Weibull} object created by a call to \code{\link[=Weibull]{Weibull()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
Determine quantiles of a Weibull distribution
}
\examples{

set.seed(27)

X <- Weibull(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Weibull distribution: \code{\link{cdf.Weibull}},
  \code{\link{pdf.Weibull}}, \code{\link{random.Weibull}}
}
\concept{Weibull distribution}
