% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Products_Drug}
\alias{Products_Drug}
\title{Drug Products}
\format{
a tibble with 19 variables:
\describe{
  \item{name}{The proprietary name(s) provided by the manufacturer for any 
  commercially available products containing this drug.}
  \item{labeller}{The corporation responsible for labelling this product.}
  \item{ndc-id}{The National Drug Code (NDC) identifier of
   the drug.}
  \item{ndc-product-code	}{The National Drug Code (NDC) product code from the
   FDA National Drug Code directory.}
  \item{dpd-id	}{Drug Product Database (DPD) identification number 
  (a.k.a. DIN) from the Canadian Drug Product Database. Only present for 
  drugs that are marketed in Canada.}
  \item{ema-product-code}{EMA product code from the European Medicines Agency
   Database. Only present for products that are authorised by central 
   procedure for marketing in the European Union.}
  \item{ema-ma-number}{EMA marketing authorisation number from the European 
  Medicines Agency Database. Only present for products that are authorised by
   central procedure for marketing in the European Union.}
  \item{started-marketing-on}{The starting date for market approval.}
  \item{ended-marketing-on}{The ending date for market approval.}
  \item{dosage-form}{The pharmaceutical formulation by which the drug is 
  introduced into the body.}
  \item{strength}{The amount of active drug ingredient provided in the 
  dosage.}
  \item{route}{The path by which the drug or product is taken into the body.}
  \item{fda-application-number}{The New Drug Application [NDA] number 
  assigned to this drug by the FDA.}
  \item{over-the-counter}{A list of Over The Counter (OTC) forms of the drug}
  \item{generic}{Whether this product is a generic drug}
  \item{approved}{Indicates whether this drug has been approved by the 
  regulating government.}
  \item{country}{The country where this commercially available drug has been 
  approved.}
  \item{source}{Source of this product information. For example, a value of 
  DPD indicates this information was retrieved from the Canadian Drug Product Database.}
  \item{parent_key}{drugbank id}
}
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
Products_Drug
}
\description{
A list of commercially available products in Canada and the United States 
that contain the drug.
}
\details{
Each drug may have one or more product.
}
\keyword{datasets}
