% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-quotes.R
\name{QuotesIndCMap}
\alias{QuotesIndCMap}
\title{Extract all quotes of a document (or an Individual Cognitivce Map)}
\usage{
QuotesIndCMap(project, doc.id)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{doc.id}{The id of a document (id of documents can be found in the data frame "documents" in the QDA project)}
}
\value{
A data frame with relationships and quotes
}
\description{
Extract all quotes of a document
}
\details{
This function creates a data frame with all quotes of a one document of a Qualitative Data Analysis (QDA) project
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

QuotesIndCMap(my.project, 2)
}
