% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrow.R
\name{check_nrow}
\alias{check_nrow}
\title{Check Number of Rows}
\usage{
check_nrow(x, nrow = TRUE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{nrow}{A flag indicating whether x should have rows (versus no rows) or a missing value indicating no requirements or a count or count range of the number of rows.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks the number of rows of a data frame.
}
\examples{
check_nrow(data.frame(x = 1), error = FALSE)
check_nrow(data.frame(x = integer(0)), error = FALSE)
check_nrow(data.frame(x = 1:2), nrow = 1, error = FALSE)
}
\seealso{
\code{\link{check_ncol}} and \code{\link{check_data}}
}
