% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character.R
\name{check_character}
\alias{check_character}
\title{Check Character}
\usage{
check_character(x, coerce = FALSE, x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a factor to a character vector and drop attributes including names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a character vector with no attributes including names.
}
\examples{
check_character("1", error = FALSE)
check_character(1:2, error = FALSE)
}
\seealso{
\code{\link{check_int}}
}
