% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.r
\name{censys_report}
\alias{censys_report}
\title{Create aggregate reports on the breakdown of a field in the result set of a query}
\usage{
censys_report(index, query, field, buckets = 50)
}
\arguments{
\item{index}{The search index to be queried. Must be one of either
\code{ipv4}, \code{websites}, or \code{certificates}.}

\item{query}{The query to be executed. For example,
\code{80.http.get.headers.server: nginx}.}

\item{field}{The field you are running a breakdown on in "dot notation",
e.g. \code{location.country_code}.}

\item{buckets}{(optional) The maximum number of values to be returned in the
report. Maximum: \code{500}. Default: \code{50}.}
}
\value{
list of information about the endpoint
}
\description{
The build report endpoint lets you run aggregate reports on the breakdown of
a field in a result set analogous to the "Build Report" functionality in the
front end. For example, if you wanted to determine the breakdown of cipher
suites selected by Top Million Websites.
}
\details{
You must have both \code{CENSYS_API_ID} and \code{CENSYS_API_SECRET} present in the
R environment for the functions in this package to work. It is highly suggested that
you place those in \code{~/.Renviron} at least for interactive work.
}
\examples{
\dontrun{
censys_report("ipv4", "80.http.get.headers.server: Apache",
              "location.country", 100)
}
}
\references{
Censys search syntax: \url{https://www.censys.io/ipv4/help};
            API doc: \url{https://www.censys.io/api/v1/docs/report}
}

