% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tree_move.R
\name{plot_tree_move}
\alias{plot_tree_move}
\title{Plot tree for a given tree move table}
\usage{
plot_tree_move(tr, main = "", add.lines = T, add.labels = T)
}
\arguments{
\item{tr}{data frame containg tree move}

\item{main}{string for main title, default is ""}

\item{add.lines}{boolean (default TRUE) add weighted mean lines?}

\item{add.labels}{boolean (default TRUE) add labels?}
}
\value{
Barplot with white scores, draws percent and black scores.
}
\description{
Plot tree (barplot percentages) for a given tree move data frame.
}
\examples{
f <- system.file("extdata", "Kasparov.gz", package = "bigchess")
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,quiet = TRUE,stat.moves = FALSE)
tr <- tree_move(subset(df,W1=="e4"),"B1")
plot_tree_move(tr,"1. e4 ... ?")
# Plot tree move openings in aggregated data
tr <- tree_move(FirstTwoMoves,"W1")
plot_tree_move(tr,paste0("1. ... ?\\n",sum(FirstTwoMoves$Freq)," total games"))
}
