% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GP_SSM.R
\name{estimate.GP}
\alias{estimate.GP}
\title{Estimate the parameters of the metamodel error estimating GP.}
\usage{
estimate.GP(ssm, type)
}
\arguments{
\item{ssm}{An SSM object.}

\item{type}{Character. Specifies the correlation function to use. Either
\code{"exp"} for squared exponential or \code{"Matern32"} for Matern 3/2.
Anything else will result in the use of a squared exponential correlation
function.#'}
}
\value{
An SSM object that is the same as the input except with
  estimates for \code{r} and \code{sigma} in the appropriate slots.
}
\description{
This function estimates the parameters of the metamodel error estimating
Gaussian process using maximum likelihood methods to identify the length
parameter \code{r} of the given correlation function.
}
\details{
Since the concentrated likelihood function is often flat, this function calls
\code{optimize} several times using different search intervals to avoid cases
when the \code{optimize} algorithm misses maxima when the interval is too
large.

The scaling parameter \code{sigma} is found analytically once \code{r}
has been determined.
}
\keyword{internal}

