% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nonpareil.R
\name{plot.Nonpareil.Curve}
\alias{plot.Nonpareil.Curve}
\title{Plot a \code{Nonpareil.Curve} object.}
\usage{
\method{plot}{Nonpareil.Curve}(x, col = NA, add = FALSE, new = !add,
  plot.observed = TRUE, plot.model = TRUE, plot.dispersion = FALSE,
  plot.diversity = TRUE, xlim = c(1000, 1e+13), ylim = c(1e-06, 1),
  main = paste("Nonpareil Curve for", x$label),
  xlab = "Sequencing effort (bp)", ylab = "Estimated Average Coverage",
  curve.lwd = 2, curve.alpha = 0.4, model.lwd = 1, model.alpha = 1,
  log = "x", arrow.length = 0.05, arrow.head = arrow.length, ...)
}
\arguments{
\item{x}{\code{Nonpareil.Curve} object to plot.}

\item{col}{Color of the curve. If passed, it overrides the colors set in the
\code{Nonpareil.Curve} object.}

\item{add}{If TRUE, it attempts to use a previous (active) canvas to plot the
curve.}

\item{new}{Inverse of `add`.}

\item{plot.observed}{Indicates if the observed (rarefied) coverage is to be plotted.}

\item{plot.model}{Indicates if the fitted model is to be plotted.}

\item{plot.dispersion}{Indicates if (and how) dispersion of the replicates should be
plotted. Supported values are:
\itemize{
  \item \code{FALSE}: no dispersion is plotted (default),
  \item \code{'sd'}: one standard deviation around the mean,
  \item \code{'ci95'}: 95% confidence interval,
  \item \code{'ci90'}: 90% confidence interval,
  \item \code{'ci50'}: 50% confidence interval,
  \item \code{'iq'}: Inter-quartile range.
}}

\item{plot.diversity}{If TRUE, the diversity estimate is plotted as a small arrow below the
Nonpareil curve.}

\item{xlim}{Limits of the sequencing effort (X-axis).}

\item{ylim}{Limits of the coverage (Y-axis).}

\item{main}{Title of the plot.}

\item{xlab}{Label of the X-axis.}

\item{ylab}{Label of the Y-axis.}

\item{curve.lwd}{Line width of the rarefied coverage.}

\item{curve.alpha}{Alpha value (from 0 to 1) of the rarefied coverage.}

\item{model.lwd}{Line width of the model.}

\item{model.alpha}{Alpha value (from 0 to 1) of the model.}

\item{log}{Axis to plot in logarithmic scale. Supported values are:
\itemize{
  \item \code{'x'}: sequencing effort (default),
  \item \code{'y'}: coverage,
  \item \code{'xy'}: both logarithmic, or
  \item \code{''}: both linear.
}}

\item{arrow.length}{If \code{plot.diversity = TRUE}, it determines the length of the
arrow to display the divsersity (as a fraction of the ylim range).}

\item{arrow.head}{If \code{plot.diversity = TRUE}, it determines the length of the
arrow head to display the diversity index (in inches).}

\item{...}{Additional graphical parameters.}
}
\value{
Retuns invisibly a \code{Nonpareil.Curve} object (same as \code{x} input).
For additional details see help for \code{summary.Nonpareil.Curve}.
}
\description{
Plot a \code{Nonpareil.Curve} object.
}
