% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmadt.hierarchical.R
\name{nmadt.hierarchical}
\alias{nmadt.hierarchical}
\title{Network Meta-Analysis Using the Hierarchical Model}
\usage{
nmadt.hierarchical(nstu, K, data, testname, directory = NULL, diag = 5,
  off_diag = 0.05, digits = 4, mu_alpha = 0, mu_beta = 0,
  mu_eta = -0, preci_alpha = 0.1, preci_beta = 0.1,
  preci_eta = 0.1, n.adapt = 5000, n.iter = 50000, n.chains = 3,
  n.burnin = floor(n.iter/2), n.thin = max(1, floor((n.iter -
  n.burnin)/50000)), conv.diag = FALSE, trace = NULL, dic = FALSE,
  mcmc.samples = FALSE)
}
\arguments{
\item{nstu}{an integer indicating the number of studies included in the dataset.}

\item{K}{an integer indicating the number of candiate test in the dataset.}

\item{data}{a list conating the input dataset to be used for meta-analysis.}

\item{testname}{a string vector of the names of the candidate tests in the dataset in the same order as presetned in the dataset.}

\item{directory}{a string specifying the designated directory to save trace plots or potential scale reduction factors calculated in the function. The default is NULL.}

\item{diag}{a number indicating the value of diagonal entries of the scale matrix R of the precision matrix \eqn{\Sigma}. The default is 5.}

\item{off_diag}{a number indicating the value of off-diagonal entries of the scale matrix R of the precision matrix \eqn{\Sigma}. The default is 0.05.}

\item{digits}{a positive integer he number of digits to the right of the decimal point to keep for the results; digits=4 by default.}

\item{mu_alpha}{a number indicating the mean of the normal distribution that the prior of the fixed effect for sensitivity follows. The default is 0.}

\item{mu_beta}{a number indicating the mean of the normal distribution that the prior of the fixed effect for specificity follows. The default is 0.}

\item{mu_eta}{a number indicating the mean of the normal distribution that the prior of the fixed effect for prevalence follows. The default is 0.}

\item{preci_alpha}{a number indicating the precision of the normal distribution that the prior of the fixed effect for sensitivity follows. The default is 0.1.}

\item{preci_beta}{a number indicating the precision of the normal distribution that the prior of the fixed effect for specificity follows. The default is 0.1.}

\item{preci_eta}{a number indicating the precision of the normal distribution that the prior of the fixed effect for prevalence follows. The default is 0.1.}

\item{n.adapt}{a positive integer indicating the number of iterations for adaptation. The default is 5,000.}

\item{n.iter}{a postive integer indicating the number of iterations in each MCMC chain. The default is 50,000.}

\item{n.chains}{a postive interger indicating the number of MCMC chains. The default is 3.}

\item{n.burnin}{a positive integer indicating the number of burn-in iterations at the beginning of each chain without saving any of the posterior samples. The default is \code{floor(n.iter/2)}.}

\item{n.thin}{the thinning rate for MCMC chains, which is used to save memory and computation time when \code{n.iter} is large.
For example, the algorithm saves only one sample in every nth iteration, where n is given by \code{n.thin}.}

\item{conv.diag}{a logical value specifying whether to compute potential scale reduction factors proposed for convergence diagnostics. The default is \code{FALSE}.}

\item{trace}{a string vector containing a subset of different quantities which can be chosen from prevalence(\code{"prev"}), sensitivity (\code{"Se"}), specificity (\code{"Sp"}), positive and negative predictive values (\code{"ppv"} and \code{"npv"} repectively), positive likelihood (\code{"LRpos"}), and negative likelihood (\code{"LRneg"}).}

\item{dic}{a logical value indicating whether the function will output the deviance information criterion (DIC) statistic. The default is \code{false}.}

\item{mcmc.samples}{a logical value indicating whether the coda samples generated in the meta-analysis. The default is \code{FALSE}.}
}
\value{
A list with the raw output for graphing the results, the effect size estimates, which lists the posterior mean, standard deviation, median, and a $95$\% equal tail credible interval for the median.
}
\description{
\code{nmadt.hierarchical} performs meta-analysis using the hierarchical model \insertCite{Ma2018}{NMADiagT} and outputs CIs for accuracy measurements.
}
\examples{
\donttest{
kangdata<-read.csv(file=system.file("extdata","kangdata.csv",package="NMADiagT"),
header=TRUE, sep=",")
set.seed(9)
kang.out <- nmadt.hierarchical(nstu=12, K=2, data=kangdata, testname=c("D-dimer","Ultrasonography"))
}
}
\references{
\insertRef{Ma2018}{NMADiagT}
}
