% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi-attribute-value-functions.R
\name{MAVF_sensitivity}
\alias{MAVF_sensitivity}
\title{Multi-attribute value function sensitivity analysis}
\usage{
MAVF_sensitivity(data, x, y, x_wt_min, x_wt_max, y_wt_min, y_wt_max)
}
\arguments{
\item{data}{A data frame}

\item{x}{Variable from data frame to represent \code{x} attribute values}

\item{y}{Variable from data frame to represent \code{y} attribute values}

\item{x_wt_min}{Lower bound anchor point for \code{x} attribute swing weight}

\item{x_wt_max}{Upper bound anchor point for \code{x} attribute swing weight}

\item{y_wt_min}{Lower bound anchor point for \code{y} attribute swing weight}

\item{y_wt_max}{Upper bound anchor point for \code{y} attribute swing weight}
}
\value{
A data frame with added variables consisting of sensitivity analysis
summary statistics for each product or service (row).
}
\description{
\code{MAVF_sensitivity} computes summary statistics for multi-attribute value
scores of \code{x} and \code{y} given a range of swing weights for each attribute
}
\details{
The sensitivity analysis performs a Monte Carlo simulation with 1000
trials for each product or service (row). Each trial randomly selects a weight
from a uniform distribution between the lower and upper bound weight parameters
and calculates the mult-attribute utility score. From these trials, summary
statistics for each product or service (row) are calculated and reported for
the final output.
}
\examples{

# Given the following data frame that contains \\code{x} and \\code{y} attribute
# values for each product or service contract, we can compute how the range of
# swing weights for each \\code{x} and \\code{y} attribute influences the multi-
# attribute value score.

df <- data.frame(contract = 1:10,
                 x_attribute = c(0.92, 0.79, 1.00, 0.39, 0.68, 0.55, 0.73, 0.76, 1.00, 0.74),
                 y_attribute = c(0.52, 0.19, 0.62, 1.00, 0.55, 0.52, 0.53, 0.46, 0.61, 0.84))

MAVF_sensitivity(df, x_attribute, y_attribute, .55, .75, .25, .45)

}
\seealso{
\code{\link{MAVF_score}} for computing the multi-attribute value score of \code{x} and \code{y}
given their respective weights

\code{\link{SAVF_score}} for computing the exponential single attribute value score
}
