% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PtsAlgHorseShoe.R
\name{PtsAlgHorseShoe}
\alias{PtsAlgHorseShoe}
\title{Function to find points along a horseshoe shape}
\usage{
PtsAlgHorseShoe(z, spacing = 1, endAngles = c(-90, 90))
}
\arguments{
\item{z}{- Distance in kilometers from the center of the horseshoe to its lower boundary}

\item{spacing}{- Degrees between successive point outlining the horseshoe shape}

\item{endAngles}{- Array of values denoting the degree of rotation for the circular part of the horseshoe distribution}
}
\value{
Returns a 2-dimensional array of decimal degree coordinates outlining a horseshoe shape
}
\description{
Function to find points along a horseshoe shape
}
\details{
Currently forces use 0,0 as the center, a height 5/4 width, and r2=2*r1 of origin (center)
}
\note{
Currently only works when endAngles are multiples of -90,90; otherwise rectangle point positions are off
}
\examples{
PtsAlgHorseShoe(z=2000,spacing=1,endAngles=c(-90,90))
}
\references{
[1] From http://mathforum.org/library/drmath/view/51816.html
}
