% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellCount.R
\name{CellCount}
\alias{CellCount}
\title{Calculates degree x degree cell counts of a specified size}
\usage{
CellCount(longs, lats, CellSize = 5, longBounds = c(-180, 180),
  latBounds = c(-90, 90))
}
\arguments{
\item{longs}{- Array of longitudinal occurrence values in decimal degrees}

\item{lats}{- Array of latitudinal occurrence values in decimal degrees}

\item{CellSize}{- Size of each cell in degree X degree}

\item{longBounds}{- Array of longitudinal boundaries in decimal degrees}

\item{latBounds}{- Array of latitudinal boundaries in decimal degrees}
}
\value{
Returns the number of cells occupied, specified cell size, and coordinate list
}
\description{
Calculates degree x degree cell counts of a specified size
}
\note{
This method uses grids cells constructed by equal degrees not area. So high latitude cells will have smaller areas than those at low latitude
}
\examples{
longs<-c(22,55,-144)
lats<-c(-12,22,-12)
CellCount(longs,lats,CellSize=5,longBounds=c(-180,180),latBounds=c(-90,90))
}
