% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHullAreaEarth.R
\name{CHullAreaEarth}
\alias{CHullAreaEarth}
\title{Performs convex hull area calculation from coordinate sets on the Earth's surface}
\usage{
CHullAreaEarth(longs, lats)
}
\arguments{
\item{longs}{- Longitudinal coordinates of occurrences in decimal degrees}

\item{lats}{- Latitudinal coordinates of occurrences in decimal degrees}
}
\value{
Returns the convex hull area is square kilometers
}
\description{
Performs convex hull area calculation from coordinate sets on the Earth's surface
}
\details{
Uses the cylindrical equal area projection in order to check if the minimum convex hull wraps around the prime meridian
}
\note{
Relies on the 'sp' package for the Polygon and chull function. Assumes latitude and longitude coordinates use the WGS84 datum
}
\examples{
longs<-c(-133,-101,56)
lats<-c(33,12,-2)
CHullAreaEarth(longs,lats)
}
