% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_analysis.r
\name{survival_univariate}
\alias{survival_univariate}
\title{Univariate Survival Regression}
\usage{
survival_univariate(
  data,
  time,
  time2 = NULL,
  event,
  names = NULL,
  strata = NULL,
  cluster = NULL,
  test = "LRT"
)
}
\arguments{
\item{data}{A dataframe including all the variable needed, one variable for
time to event and one variable for event indicator.}

\item{time}{Name of the variable used for time to event or for start time if
Start-Stop format}

\item{time2}{Stop time if the data are in Start-Stop format}

\item{event}{Name of the column used for event indicator.}

\item{names}{Names of the variables to display. Lenght must be minus 2 the
number of column of data, excluding time and event}

\item{strata}{Name of the variable used for analysis with strata}

\item{cluster}{Name of the variable used for analysis with cluster}

\item{test}{Which test to use for p-value, possible values are "LRT" for
Likelihood Ratio Test, "Wald" for Wald Test and "LogRank" for Log-Rank
Test"}
}
\value{
Return a table with model parameters for every variable included in
  data.
}
\description{
Univariate Survival Regression
}
